#!/usr/bin/perl -w

# -----------------------------------------------------------------------
# Homepage Generator 1.1
#
# The Homepage Generator is a simple tool to generate and maintain a homepage.
# The navigation structure for the homepage is configured in an XML file.
# For example the file Homepage.xml
# Other configurations can be made in a Config.xml file for example.
# 
# ./homepageGenerator.pl Homepage.xml Config.xml [DESTINATION_DIR]
#
#  Copyright by Joern Hameister (2005)
# -----------------------------------------------------------------------
#
# Changes from 1.0 to 1.1
# - The URL of banner.gif is given by a relative path now
# - The URL of the style.css is given by a relative path now
# - Fixed bug with relative paths of the banner.gif and style.css
#

use XML::Simple;
use XML::LibXML;
use File::Copy;

my %configHash;

# -----------------------------------------------------------------------
# Write the HTML start tag into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeStartHTML(*;$@) {
	print OUTPUT "<html>\n";
}

# -----------------------------------------------------------------------
# Write the HTML end tag into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------

sub writeEndHTML(*;$@) {
	print OUTPUT "</html>\n";
}

# -----------------------------------------------------------------------
# Write the HTML header into the HTML file.
# @param OUTPUT
# @param Title
#
# -----------------------------------------------------------------------

sub writeHeader(*;$@) {
	$title = $_[1];
	$main = $_[2];
	
	print OUTPUT "<head>\n";
	print OUTPUT "<title>$title</title>\n";
	if($main == 0) {
		# Parent directory if it is not of type main
		print OUTPUT "<link rel=\"stylesheet\" type=\"text/css\" href=\"../style.css\">\n";
	}
	else {
		# Use the acutal directory if the page if of type main
		print OUTPUT "<link rel=\"stylesheet\" type=\"text/css\" href=\"./style.css\">\n";
	}
		
	print OUTPUT "<meta name=\"robots\" content=\"index, follow\">\n";
	print OUTPUT "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n";
	print OUTPUT "</head>\n";
}


# -----------------------------------------------------------------------
# Write the HTML body start into the HTML file.
# @param OUTPUT
# @param bgcolor
#
# -----------------------------------------------------------------------
sub writeStartBody(*;$@) {
	print OUTPUT "<body leftmargin=\"0\" topmargin=\"0\" bottommargin=\"0\" bgcolor=\"$_[1]\" marginheight=\"0\" marginwidth=\"0\">\n";
}

# -----------------------------------------------------------------------
# Write the HTML body end into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeEndBody(*;$@) {
	print OUTPUT "</body>\n";
}

# -----------------------------------------------------------------------
# Write the HTML main table into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------

sub writeStartTableMain(*;$@) {
 print OUTPUT "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
}

# -----------------------------------------------------------------------
# Write the HTML body end into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeEndTable(*;$@) {
	print OUTPUT "</Table>\n";
}

# -----------------------------------------------------------------------
# Write the first line of the main table  into the HTML file.
# @param OUTPUT
# @param bgcolor
# @param Homepage URL
# @param Banner GIF
# @param Alt text for image
#
# -----------------------------------------------------------------------
sub writeTableTitle(*;$@) {
	print OUTPUT "<tr>\n";
  print OUTPUT "<td colspan=\"3\" bgcolor=\"$_[1]\">\n";
  print OUTPUT "<a href=\"$_[2]\">\n";
  print OUTPUT "<img src=\"$_[3]\" alt=\"$_[4]\" border=\"0\" height=\"46\" width=\"436\">\n";
  print OUTPUT "</a>\n";
  print OUTPUT "</td>\n";
  print OUTPUT "</tr>\n";
}

# -----------------------------------------------------------------------
# Write a line in a table with a specified color into the HTML file.
# @param OUTPUT
# @param bgcolor
#
# -----------------------------------------------------------------------
sub writeTableBorderLine(*;$@) {
 print OUTPUT "<tr>\n";
 print OUTPUT "<td colspan=\"3\" bgcolor=\"$_[1]\" height=\"1\"></td>\n";
 print OUTPUT "</tr>\n";
}

# -----------------------------------------------------------------------
# Write the TopNavigation into the HTML file.
# @param OUTPUT
# @param bgcolor
# @param Homepage URL
# @param separator
# @param selected topNavigation id
# @param DOM Root
#
# -----------------------------------------------------------------------
sub writeTopNavigation(*;$@) {
	print OUTPUT "<tr>\n";
  print OUTPUT "<td colspan=\"3\" align=\"left\" bgcolor=\"$_[1]\">\n";
  print OUTPUT "<div style=\"margin-left: 17px; margin-top: 1px; margin-bottom: 2px;\">\n";
  print OUTPUT "$_[3]&nbsp;";
  
  my @topNavigations = $_[5]->findnodes( "//TopNavigation" );
  foreach $topNavigation (@topNavigations) {
  	  # Is displayed in the top navigation
  		my $desription = getTopNavigationDescription($topNavigation);
  		# Used for subdirectories  		
			my $id = $topNavigation->getAttribute('id');

			# The	first LeftNavigation is the main page of the TopNavigation
			@childNodes = $topNavigation->childNodes;
			$leftNavigationIndexId = $childNodes[3]->getAttribute('id');

			
			# Create a link with target [URL]/[TopNavigationId]/[LeftNavigationId].html
			# If it is the selected point make it bold
			if($id eq $_[4]) {
				print OUTPUT "<a class=\"nav\" href=\"$_[2]/$id/$leftNavigationIndexId.html\"><B>$description</B></a>";
			}
			else {
				print OUTPUT "<a class=\"nav\" href=\"$_[2]/$id/$leftNavigationIndexId.html\">$description</a>";
			}
			print OUTPUT "&nbsp;$_[3]&nbsp;";
  }
  
  print OUTPUT "</div>\n";
  print OUTPUT "</td>\n";
  print OUTPUT "</tr>\n";
}

# -----------------------------------------------------------------------
# Write table row start into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeStartContentRow(*;$@) {
	print OUTPUT "<TR>\n";
}

# -----------------------------------------------------------------------
# Write table row end into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeEndContentRow(*;$@) {
	print OUTPUT "</TR>\n";
}

# -----------------------------------------------------------------------
# Write left navigation into the HTML file.
# @param OUTPUT
# @param bgcolor
# @param URL
# @param separator
# @param selected topNavigation id
# @param TopNavigation Node
#
# -----------------------------------------------------------------------
sub writeLeftNavigation(*;$@) {

  print OUTPUT "<td class=\"nav\" bgcolor=\"$_[1]\" height=\"400\" nowrap=\"nowrap\" valign=\"top\" width=\"142\">\n";
  print OUTPUT "<div style=\"margin: 17px 10px 17px 17px; line-height: 18px;\">\n";

	@leftNavigations = $_[5]->childNodes;
	foreach my $leftNavigation (@leftNavigations) {
		# Is it an element node?
		if($leftNavigation->nodeType==1) {
			if($leftNavigation->nodeName eq "Description") {
				my $nodeDescription = $leftNavigation->firstChild->nodeValue;
				print OUTPUT "<b>$nodeDescription</b>\n";
			}
			elsif($leftNavigation->nodeName eq "LeftNavigation") {
				my $id = $leftNavigation->getAttribute('id');

				my @leftNavigationChildNodes = $leftNavigation->childNodes;
				foreach $leftNavigationChildNode (@leftNavigationChildNodes) {
					if($leftNavigationChildNode->nodeName eq "Description") {
						my $nodeDescription = $leftNavigationChildNode->firstChild->nodeValue;
						print OUTPUT "<br>$_[3]&nbsp;<a class=\"nav\" href=\"$_[2]/$_[4]/$id.html\"><b>$nodeDescription</b></a>\n";
					}
				}
			}
		}
	}
	print OUTPUT "<p></p></div>\n";
  print OUTPUT "</td>\n";
	


}

# -----------------------------------------------------------------------
# Write empty column into the HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub writeEmptyColumn(*;$@) {
	print OUTPUT "<td bgcolor=\"$_[1]\" width=\"1\"></td>\n";
}


# -----------------------------------------------------------------------
# Returns the value of the Description Element of the TopNavigation Node
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub getTopNavigationDescription {
	$topNavigation = $_[0];
	@descriptionNodes = $topNavigation->childNodes;
	foreach my $descriptionNode (@descriptionNodes) {
		# Is it an element node?
		if($descriptionNode->nodeType==1) {
			if($descriptionNode->nodeName eq "Description") {
				# Get element content of description element
				$description = $descriptionNode->firstChild->nodeValue;
				return $description;
			}
		}
	}	
}

# -----------------------------------------------------------------------
# Write page content into a column of the HTML file.
# @param OUTPUT
# @param separator
# @param topNavigation Node
# @param leftNavigation Node
#
# -----------------------------------------------------------------------
sub writePageContent(*;$@) {
	$separator = $_[1];
	$topNavigation = $_[2];
	$leftNavigation = $_[3];
	
  print OUTPUT "<td valign=\"top\" width=\"90%\">\n";
	print OUTPUT "<div style=\"margin-left: 20px; margin-top: 17px; margin-bottom: 17px;\">\n";

  @childNodes = $leftNavigation->childNodes;
  foreach $childNode (@childNodes) {
  	
		if($childNode->nodeType==1) {
			if($childNode->nodeName eq "Description") {
				my $nodeDescription = $childNode->firstChild->nodeValue;
				my $topNativationDescription = getTopNavigationDescription($topNavigation);
				print OUTPUT "<h1><font color=\"#000000\">$separator $topNativationDescription $separator $nodeDescription $separator</font></h1>\n";
			}
			elsif($childNode->nodeName eq "Content") {
				my $contentFile = $childNode->firstChild->nodeValue;
				
				# Import the content file and write it into the HTML output file
				my  $isOpen = open(CONTENTFILE, "<", $contentFile);
				if(!$isOpen) {
					print  "=====>Cannot find $contentFile\n";
				}
				else {
					print "Import $contentFile\n";
					while(defined($line = <CONTENTFILE>)) {
						chomp($line);
						print OUTPUT $line;
					}
				
				close(CONTENTFILE);
			}
			}
		}
  	
  }

	print OUTPUT "</div>\n";
  print OUTPUT "</td>\n";
}



# -----------------------------------------------------------------------
# Write page content into a column of the HTML file.
# @param OUTPUT
# @param bgcolor
# @param bgcolor
#
# -----------------------------------------------------------------------
sub writeCopyright(*;$@) {

print OUTPUT "<tr>\n";
print OUTPUT "    <td bgcolor=\"$_[1]\" nowrap=\"nowrap\">\n";
print OUTPUT "      <div style=\"margin: 20px 10px 4px 17px; font-size: 10px;\">\n";
print OUTPUT "      &copy; 2005 Jrn Hameister\n";
print OUTPUT "      </div>\n";
print OUTPUT "    </td>\n";
print OUTPUT "    <td bgcolor=\"$_[2]\" width=\"1\"></td>\n";
print OUTPUT "    <td>&nbsp;</td>\n";
print OUTPUT "</tr>\n";

}

# -----------------------------------------------------------------------
# Create HTML file.
# @param OUTPUT
#
# -----------------------------------------------------------------------
sub createHTML(*;$@) {
	$topNavigationId = $_[1];
	$root = $_[2];
	$topNavigation = $_[3];
	$targetDir = $_[4];
	$leftNavigation = $_[5];
	$main = $_[6];
	
	$bodyBackgroundColor = $configHash{"bodyBackgroundColor"}; #"#ffffff";
	$bannerBackgroundColor = $configHash{"bannerBackgroundColor"}; # "#dddcdc";
	$firstLineColor = $configHash{"firstLineColor"}; #"#c9c8c8";
	$topNavigationBackgroundColor = $configHash{"topNavigationBackgroundColor"}; #"#f4f3f3";
	$secondLineColor = $configHash{"secondLineColor"}; #"#e7e5e5";
	$leftNavigationColor = $configHash{"leftNavigationColor"}; #"#f4f3f3";
	$leftNavigationLineColor = $configHash{"leftNavigationLineColor"}; #"#e7e5e5";
	$separator = $configHash{"separator"}; #"::";
	$homepageTitel = $configHash{"homepageTitel"}; #"Jrn Hameister's Homepage";
	$url = $configHash{"url"};
	
	# START
	writeStartHTML(OUTPUT);
	writeHeader(OUTPUT,$homepageTitel, $main);
	writeStartBody(OUTPUT,$bodyBackgroundColor);
	
	# START TABLE
	writeStartTableMain(OUTPUT);
	
	# TOP Navigation
	if($main==0) {
		# Parent directory if it is not of type main
		writeTableTitle(OUTPUT, $bannerBackgroundColor, "$url/index.html", "../banner.gif", $homepageTitel);
	}
	else {
		# Use the acutal directory if the page if of type main
		writeTableTitle(OUTPUT, $bannerBackgroundColor, "$url/index.html", "./banner.gif", $homepageTitel);
	}
	writeTableBorderLine(OUTPUT, $firstLineColor);
	writeTopNavigation(OUTPUT, $topNavigationBackgroundColor, $url, $separator, $topNavigationId, $root);
	writeTableBorderLine(OUTPUT, $secondLineColor);
	
	# Left Navigation, Page Content
	writeStartContentRow(OUTPUT);
	writeLeftNavigation(OUTPUT, $leftNavigationColor, $url, $separator , $topNavigationId ,$topNavigation );
	writeEmptyColumn(OUTPUT, $leftNavigationLineColor);
	writePageContent(OUTPUT, $separator, $topNavigation, $leftNavigation);
	writeEndContentRow(OUTPUT);
	
	# Copyright
	writeCopyright(OUTPUT, $leftNavigationColor, $leftNavigationLineColor);
	writeTableBorderLine(OUTPUT, $leftNavigationLineColor);
	
	# END TABLE
	writeEndTable(OUTPUT);
	
	# END
	writeEndBody(OUTPUT);
	writeEndHTML(OUTPUT);	
	
}


# -----------------------------------------------------------------------
# Write the CSS file.
# @param targetDirectory
#
# -----------------------------------------------------------------------
sub writeCSS {
	$targetDir = $_[0];
	open(CSSOUTPUT, ">" , $targetDir."/style.css");	
	
	print CSSOUTPUT "body, p, td, li, h1, h2, h3 { font-family: Verdana, Arial, Helvetica, Geneva, sans-serif; }";
	print CSSOUTPUT "body, p, td, li, h2, h3     { font-size: 12px; }";
	print CSSOUTPUT "h1, h2, h3  { font-weight: bold; color:#323777; margin-bottom: 11px; }\n";
	print CSSOUTPUT "h1          { font-size:14px; }\n";
	print CSSOUTPUT "h2, h3      { margin-top: 17px; }\n";
	print CSSOUTPUT ".header     { font-weight: bold; color:#323777; margin-bottom: 11px; }\n";
	print CSSOUTPUT "p           { margin-top: 14px; }\n";
	print CSSOUTPUT "a           { text-decoration: none; color:#323788; }\n";
	print CSSOUTPUT "a:hover     { text-decoration: underline; }\n";
	print CSSOUTPUT "a.nav       { text-decoration: none; color:#000000; }\n";
	print CSSOUTPUT "a.nav:hover { text-decoration: underline; }\n";
	print CSSOUTPUT "pre         { font-family:Courier New, Courier, monospace; font-size:12px; }\n";
	print CSSOUTPUT "ul          { list-style-type: square; margin-top: 2px;}\n";
	print CSSOUTPUT "td.header   { color: #FFFFFF; background-color:#323777;}\n";
	print CSSOUTPUT "td.cell     { background-color:#FFFFFF;}\n";
	
	close(CSSOUTPUT);
}

# -----------------------------------------------------------------------
# Read the configuration entries from the XML file.
# @param root Nodes
#
# -----------------------------------------------------------------------
sub readConfig {
	$configFilename = $_[0];

	my $parser = XML::LibXML->new();
	my $dom = $parser->parse_file($configFilename);
	my $root = $dom->getDocumentElement;
	my @configs = $root->findnodes( "//Config" );
	my $config = $configs[0];
	my @configEntries = $config->childNodes;
	foreach $configEntry (@configEntries) {
		if($configEntry->nodeType==1) {
			$key = $configEntry->nodeName;
			$value = $configEntry->firstChild->nodeValue;
			$configHash{$key} = $value;
			# print "$key = $value\n";
		}
	}
}

# -----------------------------------------------------------------------
#
# MAIN Programm
#
# -----------------------------------------------------------------------

if(@ARGV!=3) {
	print "This programm generates from an input XML file and a XML config file a homepage framework.\n";
	print "Parameter 1. Input XML file\nParameter 2. Config XML file\nParameter 3. target directory\n";
}
else { 
	print "Read from $ARGV[0] (Inputfile)\n";
	print "Read configuration from $ARGV[1] (Outputdirectory)\n";
  print "Write to $ARGV[2] (Outputdirectory)\n";
	
	
	my $XMLINPUTFILE = $ARGV[0];
	my $CONFIGFILE = $ARGV[1];
	my $TARGETDIR = $ARGV[2];
	
	if (!-e $XMLINPUTFILE) {
		print "================>$XMLINPUTFILE not found\n";
	}
	if (!-e $CONFIGFILE) {
		print "================>$CONFIGFILE not found\n";
	}
	if (!-e $TARGETDIR) {
		print "$TARGETDIR does not exist. Will be created...\n";
		mkdir $TARGETDIR;
	}
	
	
	
	# Open XML Config file
	my $parser = XML::LibXML->new();
	my $dom = $parser->parse_file($XMLINPUTFILE);
	my $root = $dom->getDocumentElement;
	
	readConfig($CONFIGFILE);
	
	writeCSS($TARGETDIR);
	copy("./banner.gif", $TARGETDIR."/banner.gif");
	
	my @topNavigations = $root->findnodes( "//TopNavigation" );
	
	foreach my $topNavigation (@topNavigations) {
		#my $topNavigation = $topNavigations[2];
		my $topNavigationId = $topNavigation->getAttribute('id') ;
	
		@leftNavigations = $topNavigation->childNodes;
		foreach my $leftNavigation (@leftNavigations) {
			# Is it an element node?
			if($leftNavigation->nodeType==1) {
				if($leftNavigation->nodeName eq "LeftNavigation") {
					my $id = $leftNavigation->getAttribute('id');
					
	
					# Create Main page				
					if($leftNavigation->hasAttribute('type')) {
						my $main = $leftNavigation->getAttribute('type');
						if($main eq "Main") {
							$targetFile = $TARGETDIR."/".$id.".html";
							print "Generating file: $targetFile\n";
							open(OUTPUT, ">", $targetFile);
							my $main = 1;
							createHTML(OUTPUT, $topNavigationId, $root, $topNavigation, $TARGETDIR, $leftNavigation, $main);
							close(OUTPUT);
						}
						
					}
		
					# Open Output HTML file
					$targetDir = $TARGETDIR."/".$topNavigationId;
					$targetFile = $targetDir."/".$id.".html";
					mkdir $targetDir;
					print "Generating file: $targetFile\n";
					open(OUTPUT, ">", $targetFile);
					my $main = 0;
					createHTML(OUTPUT, $topNavigationId, $root, $topNavigation, $TARGETDIR, $leftNavigation, $main);
					close(OUTPUT);
				}
			}
		}
	}
}

print "End of Processing...\n"