/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.wizard.steps;

import de.hameister.fractal.util.ColorFactory;
import de.hameister.fractal.view.FractalFrame;
import de.hameister.fractal.vo.ParameterVO;
import de.hameister.fractal.wizard.steps.FractalAbstractStepDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class FractalDialog
extends FractalAbstractStepDialog {
    private ParameterVO _parameterVO;
    private JComboBox _typeBox;
    private String[] _types;
    private JComboBox _colorBox;
    private String[] _colors;
    private JTextField _zi;
    private JTextField _z;
    private JSlider _convergenceColor;
    private JCheckBox _convergenceCheck;

    public FractalDialog(FractalFrame parentFrame, ParameterVO parameterVO, String[] types, String[] colors) {
        super(parentFrame);
        this.setTitle("Parameters");
        this._parameterVO = parameterVO;
        this._types = types;
        this._colors = colors;
        this.init();
    }

    private void init() {
        String[] buttons = new String[]{"Cancel", "OK"};
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel choosePanel = new JPanel();
        choosePanel.add(this.createTypePanel());
        choosePanel.add(this.createColorPanel());
        choosePanel.add(this.createConvergenceColor());
        choosePanel.add(this.createParameterPanel());
        choosePanel.add(this.createConvergenceCheck());
        container.add((Component)choosePanel, "Center");
        container.add((Component)this.createButtonPanel(buttons), "South");
        if (this._parameterVO.getType() != null) {
            this._typeBox.setSelectedItem(this._parameterVO.getType());
        }
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this._parentFrame);
        this.pack();
        this.setSize(220, 300);
    }

    private JPanel createConvergenceColor() {
        int FPS_MIN = 0;
        int FPS_MAX = 50;
        int FPS_INIT = this._parameterVO.getConvergenceColor();
        JLabel label = new JLabel("Convergence color", 0);
        this._convergenceColor = new JSlider(0, FPS_MIN, FPS_MAX, FPS_INIT);
        this._convergenceColor.setMajorTickSpacing(10);
        this._convergenceColor.setMinorTickSpacing(5);
        this._convergenceColor.setPaintTicks(true);
        this._convergenceColor.setPaintLabels(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Black"));
        labelTable.put(new Integer(FPS_MAX), new JLabel("White"));
        this._convergenceColor.setLabelTable(labelTable);
        this._convergenceColor.setToolTipText("0 ist black. 255 is white.");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)this._convergenceColor, "Center");
        return panel;
    }

    private JPanel createConvergenceCheck() {
        this._convergenceCheck = new JCheckBox("Strict convergence check");
        this._convergenceCheck.setActionCommand("convergenceCheck");
        this._convergenceCheck.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(this._convergenceCheck);
        return panel;
    }

    private JPanel createParameterPanel() {
        JPanel panel = new JPanel();
        JPanel panelZi = new JPanel();
        panelZi.setLayout(new BorderLayout());
        JLabel labelZi = new JLabel("zi:");
        this._zi = new JTextField(3);
        this._zi.setText(String.valueOf(this._parameterVO.getCi()));
        panelZi.add((Component)labelZi, "West");
        panelZi.add((Component)this._zi, "East");
        JPanel panelZ = new JPanel();
        panelZ.setLayout(new BorderLayout());
        JLabel labelZ = new JLabel("z:");
        this._z = new JTextField(3);
        this._z.setText(String.valueOf(this._parameterVO.getCr()));
        panelZ.add((Component)labelZ, "West");
        panelZ.add((Component)this._z, "East");
        panel.add(panelZi);
        panel.add(panelZ);
        this._zi.setEnabled(false);
        this._zi.setEditable(false);
        this._z.setEnabled(false);
        this._z.setEditable(false);
        return panel;
    }

    private JPanel createColorPanel() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Color:");
        this._colorBox = new JComboBox<String>(this._colors);
        panel.add(label);
        panel.add(this._colorBox);
        return panel;
    }

    private JPanel createTypePanel() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Types:");
        this._typeBox = new JComboBox<String>(this._types);
        this._typeBox.setActionCommand("Types");
        this._typeBox.addActionListener(this);
        panel.add(label);
        panel.add(this._typeBox);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("OK")) {
            System.out.println("OK");
            this._parameterVO.setType((String)this._typeBox.getSelectedItem());
            this._parameterVO.setColor(ColorFactory.getColor((String)this._colorBox.getSelectedItem()));
            this._parameterVO.setConvergenceColor(this._convergenceColor.getValue());
            this._parameterVO.setConvergenceCheck(this._convergenceCheck.isSelected());
            try {
                this._parameterVO.setCi(Double.parseDouble(this._zi.getText()));
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
                return;
            }
            try {
                this._parameterVO.setCr(Double.parseDouble(this._z.getText()));
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
                return;
            }
            this.dispose();
        } else if (command.equals("Cancel")) {
            System.out.println("Cancel");
            this._isCancelled = true;
            this.dispose();
        } else if (command.equals("Types")) {
            if (((String)this._typeBox.getSelectedItem()).equals("Julia")) {
                this._zi.setEnabled(true);
                this._zi.setEditable(true);
                this._z.setEnabled(true);
                this._z.setEditable(true);
                this._convergenceCheck.setEnabled(false);
            } else {
                this._zi.setEnabled(false);
                this._zi.setEditable(false);
                this._z.setEnabled(false);
                this._z.setEditable(false);
                this._convergenceCheck.setEnabled(true);
            }
        }
    }
}

