/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.view;

import de.hameister.fractal.vo.ParameterVO;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class FractalPanel
extends JPanel {
    private int _x;
    private int _y;
    private static final int PIXELSIZE = 1;
    private static final int OFFSIZE_X = 0;
    private static final int OFFSIZE_Y = 0;
    private Image _offscreenImage;
    private int _color_scheme;
    private int[][] _points;
    private ParameterVO _parameterVO;

    public FractalPanel(int[][] points, ParameterVO parameterVO) {
        this._points = points;
        this._parameterVO = parameterVO;
        if (this._parameterVO != null) {
            this._color_scheme = this._parameterVO.getColor();
        }
        if (points != null) {
            this._y = points[0].length;
            this._x = points.length;
            this._offscreenImage = new BufferedImage(this._x, this._y, 1);
            this.paintIntoGraphics();
        }
    }

    public ParameterVO getParameters() {
        return this._parameterVO;
    }

    public void setColorSchema(int color) {
        this._color_scheme = color;
    }

    public void save(File file) {
        try {
            this._offscreenImage = new BufferedImage(this._x, this._y, 1);
            this.paintIntoGraphics();
            ImageIO.write((RenderedImage)((BufferedImage)this._offscreenImage), "jpg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void paintIntoGraphics() {
        Graphics grOff = this._offscreenImage.getGraphics();
        int imax = 50;
        int x = 0;
        int xx = 0;
        while (x < this._x) {
            int y = 0;
            int yy = 0;
            while (y < this._y) {
                int r = 0;
                int g = 0;
                int b = 0;
                try {
                    double t1 = 1.0 * (double)this._points[x][y] / (double)imax;
                    int c1 = (int)Math.min(510.0 * t1, 255.0);
                    int c2 = (int)Math.max(255.0 * (2.0 * t1 - 1.0), 0.0);
                    switch (this._color_scheme) {
                        case 0: {
                            r = c1;
                            g = c2;
                            b = c2;
                            break;
                        }
                        case 1: {
                            r = c2;
                            g = c1;
                            b = c2;
                            break;
                        }
                        case 2: {
                            r = c2;
                            g = c2;
                            b = c1;
                            break;
                        }
                        case 3: {
                            r = c1;
                            g = c1;
                            b = c2;
                            break;
                        }
                        case 4: {
                            r = c2;
                            g = c1;
                            b = c1;
                            break;
                        }
                        case 5: {
                            r = c1;
                            g = c2;
                            b = c1;
                        }
                    }
                    grOff.setColor(new Color(r, b, g));
                }
                catch (IllegalArgumentException ex) {
                    System.out.println(r);
                    System.out.println(b);
                    System.out.println(g);
                    System.out.println("Color=" + this._points[x][y]);
                    ex.printStackTrace();
                }
                grOff.fillRect(xx + 0, yy + 0, 1, 1);
                ++y;
                ++yy;
            }
            ++x;
            ++xx;
        }
    }

    public void paint(Graphics gr) {
        if (this._offscreenImage != null) {
            gr.drawImage(this._offscreenImage, 0, 0, this);
        }
    }
}

