/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.view;

import de.hameister.fractal.julia.Julia;
import de.hameister.fractal.mandelbrot.Mandelbrot;
import de.hameister.fractal.menu.FractalMenuBar;
import de.hameister.fractal.view.FractalPanel;
import de.hameister.fractal.vo.ParameterVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class FractalFrame
extends JFrame
implements MouseListener {
    private FractalPanel _fractalPanel;
    private static int FRACTOR = 40;
    private Point _pStart;
    private Point _pEnd;

    public FractalFrame() {
        super("Fractal");
        System.out.println("Start...");
        ImageIcon icon = new ImageIcon("./config/blauSmall.gif");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(25 * FRACTOR, 21 * FRACTOR));
        this._fractalPanel = new FractalPanel(null, null);
        this.getContentPane().add((Component)this._fractalPanel, "Center");
        this._fractalPanel.repaint();
        FractalMenuBar menuBar = new FractalMenuBar(this);
        this.setJMenuBar(menuBar.createMenuBar());
        this.addMouseListener(this);
    }

    public void setFractalPanel(FractalPanel fractalPanel) {
        this._fractalPanel = fractalPanel;
    }

    public FractalPanel getFractalPanel() {
        return this._fractalPanel;
    }

    public static void main(String[] args) {
        FractalFrame fractalFrame = new FractalFrame();
        fractalFrame.pack();
        fractalFrame.setVisible(true);
        System.out.println("Finished...");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this._pStart = e.getPoint();
        System.out.println("Start:" + this._pStart.getX() + " " + this._pStart.getY());
    }

    public void mouseReleased(MouseEvent e) {
        this._pEnd = e.getPoint();
        System.out.println("End:" + this._pEnd.getX() + " " + this._pEnd.getY());
        ParameterVO parameterVO = this._fractalPanel.getParameters();
        if (parameterVO.getType() != null && parameterVO.getType().equals("Mandelbrot")) {
            System.out.println("Processing Mandelbrot");
            Mandelbrot mandelbrot = new Mandelbrot(parameterVO);
            this._fractalPanel = new FractalPanel(mandelbrot.createPoints(), parameterVO);
        } else if (parameterVO.getType() != null && parameterVO.getType().equals("Julia")) {
            System.out.println("Processing Julia");
            Julia julia = new Julia(parameterVO);
            this._fractalPanel = new FractalPanel(julia.createPoints(), parameterVO);
        }
        if (this._fractalPanel != null) {
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)this._fractalPanel, "Center");
            this.pack();
            this._fractalPanel.repaint();
            this.repaint();
            this.setFractalPanel(this._fractalPanel);
        }
    }
}

