/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.menu;

import de.hameister.fractal.menu.JPGFilter;
import de.hameister.fractal.view.FractalFrame;
import de.hameister.fractal.view.FractalPanel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;

public class FractalSaveAsMenuItem
extends JMenuItem
implements MouseListener {
    private FractalFrame _fractalFrame;
    private String _text;

    public FractalSaveAsMenuItem(FractalFrame fractalFrame, String text) {
        super(text);
        this.setActionCommand(text);
        this._fractalFrame = fractalFrame;
        this._text = text;
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (((JMenuItem)e.getSource()).getActionCommand().equals(this._text)) {
            FractalPanel fractalPanel = this._fractalFrame.getFractalPanel();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new JPGFilter());
            fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (file != null) {
                if (file.getName().endsWith(".jpg")) {
                    fractalPanel.save(file);
                } else {
                    fractalPanel.save(new File(String.valueOf(file.getAbsolutePath()) + ".jpg"));
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }
}

