/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.menu;

import de.hameister.fractal.julia.Julia;
import de.hameister.fractal.mandelbrot.Mandelbrot;
import de.hameister.fractal.view.FractalFrame;
import de.hameister.fractal.view.FractalPanel;
import de.hameister.fractal.vo.ParameterVO;
import de.hameister.fractal.wizard.FractalNewWizard;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;

public class FractalNewMenuItem
extends JMenuItem
implements MouseListener {
    private FractalFrame _parentFrame;
    private String _text;
    private ParameterVO _parameterVO;

    public FractalNewMenuItem(FractalFrame parentFrame, String text) {
        super(text);
        this.setActionCommand(text);
        this._parentFrame = parentFrame;
        this._text = text;
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (((JMenuItem)e.getSource()).getActionCommand().equals(this._text)) {
            FractalNewWizard wizard = new FractalNewWizard(this._parentFrame, this._parameterVO);
            wizard.open();
            this._parameterVO = wizard.getParameterVO();
            FractalPanel fractalPanel = null;
            if (this._parameterVO.getType() != null && this._parameterVO.getType().equals("Mandelbrot")) {
                Mandelbrot mandelbrot = new Mandelbrot(this._parameterVO);
                fractalPanel = new FractalPanel(mandelbrot.createPoints(), this._parameterVO);
            } else if (this._parameterVO.getType() != null && this._parameterVO.getType().equals("Julia")) {
                Julia julia = new Julia(this._parameterVO);
                fractalPanel = new FractalPanel(julia.createPoints(), this._parameterVO);
            }
            if (fractalPanel != null) {
                this._parentFrame.getContentPane().removeAll();
                this._parentFrame.getContentPane().add(fractalPanel, "Center");
                this._parentFrame.pack();
                fractalPanel.repaint();
                this._parentFrame.repaint();
                this._parentFrame.setFractalPanel(fractalPanel);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }
}

