/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.mandelbrot;

import de.hameister.fractal.complex.Complex;
import de.hameister.fractal.vo.ParameterVO;

public class Mandelbrot {
    private ParameterVO _parameterVO;
    private static double EPSILON = 0.01;
    private static int DEEP = 50;
    private static int FRACTOR = 40;
    private static final double GRAN = 1.0 / (double)(FRACTOR * 10);
    private static int xStart = 20 * FRACTOR;
    private static int xEnd = 5 * FRACTOR;
    private static int yStart = 10 * FRACTOR;
    private static int yEnd = 10 * FRACTOR;
    private int[][] _points;

    public Mandelbrot(ParameterVO parameterVO) {
        this._parameterVO = parameterVO;
        this._points = new int[26 * FRACTOR][21 * FRACTOR];
    }

    public int[][] createPoints() {
        if (this._parameterVO.isConvergenceCheck()) {
            int x = -xStart;
            while (x <= xEnd) {
                int y = -yStart;
                while (y <= yEnd) {
                    this._points[x + Mandelbrot.xStart][y + Mandelbrot.yStart] = this.checkConvergence((double)y * GRAN, (double)x * GRAN);
                    ++y;
                }
                ++x;
            }
        } else {
            int x = -xStart;
            while (x <= xEnd) {
                int y = -yStart;
                while (y <= yEnd) {
                    this._points[x + Mandelbrot.xStart][y + Mandelbrot.yStart] = this.checkFast((double)y * GRAN, (double)x * GRAN);
                    ++y;
                }
                ++x;
            }
        }
        return this._points;
    }

    public int checkFast(double ci, double c) {
        double zi = 0.0;
        double z = 0.0;
        int i = 0;
        while (i < DEEP) {
            double zT = z * z - zi * zi;
            double ziT = 2.0 * (z * zi);
            if ((z = zT + c) * z + (zi = ziT + ci) * zi >= 4.0) {
                return i;
            }
            ++i;
        }
        return this._parameterVO.getConvergenceColor();
    }

    public int checkConvergence(double ci, double cr) {
        double zi = 0.0;
        double z = 0.0;
        double zi_LAST = 0.0;
        double z_LAST = 999.0;
        int i = 0;
        while (i < DEEP) {
            if (Mandelbrot.equal(zi, z, zi_LAST, z_LAST)) {
                return i;
            }
            zi_LAST = zi;
            z_LAST = z;
            double ziT = 2.0 * (z * zi);
            double zT = z * z - zi * zi;
            z = zT + cr;
            zi = ziT + ci;
            ++i;
        }
        return this._parameterVO.getConvergenceColor();
    }

    public static int check(double im, double re) {
        int counter = 0;
        Complex c = new Complex(im, re);
        Complex x = new Complex(0.0, 0.0);
        Complex oldX1 = new Complex(0.0, 999.0);
        int i = 0;
        while (i < DEEP) {
            if (x.equal(oldX1, EPSILON)) {
                counter = i;
                break;
            }
            oldX1 = x;
            x = x.mult(x).add(c);
            ++i;
        }
        return counter;
    }

    private static double fabs(double a) {
        if (a < 0.0) {
            return -a;
        }
        return a;
    }

    public static boolean equal(double xi, double x, double yi, double y) {
        return Mandelbrot.fabs(x - y) < EPSILON && Mandelbrot.fabs(xi - yi) < EPSILON;
    }
}

