/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.julia;

import de.hameister.fractal.vo.ParameterVO;

public class Julia {
    private static int DEEP = 50;
    private static int FRACTOR = 25;
    private static final double GRAN = 1.0 / (double)(FRACTOR * 10);
    private static int xS = 20;
    private static int xE = 20;
    private static int yS = 15;
    private static int yE = 15;
    private static int xStart = xS * FRACTOR;
    private static int xEnd = xE * FRACTOR;
    private static int yStart = yS * FRACTOR;
    private static int yEnd = yE * FRACTOR;
    private int[][] _points;
    private double _ci;
    private double _cr;
    private int _convergenceColor;
    private ParameterVO _parameterVO;

    public Julia(ParameterVO parameterVO) {
        this._parameterVO = parameterVO;
        this._ci = this._parameterVO.getCi();
        this._cr = this._parameterVO.getCr();
        this._convergenceColor = this._parameterVO.getConvergenceColor();
        this._points = new int[(xS + xE + 1) * FRACTOR][(yS + yE + 1) * FRACTOR];
    }

    public int[][] createPoints() {
        int x = -xStart;
        while (x <= xEnd) {
            int y = -yStart;
            while (y <= yEnd) {
                this._points[x + Julia.xStart][y + Julia.yStart] = this.checkJulia((double)y * GRAN, (double)x * GRAN, this._ci, this._cr);
                ++y;
            }
            ++x;
        }
        return this._points;
    }

    public int checkJulia2(double ci, double cr) {
        double x = 0.6;
        double y = -0.4;
        double t1 = Math.max(Math.abs(x), (double)Math.abs(2));
        double t2 = Math.max(Math.abs(y), (double)Math.abs(2));
        double R2 = Math.sqrt(t1 * t1 + t2 * t2);
        int i = 0;
        double x2 = x * x;
        double y2 = y * y;
        while (i < DEEP) {
            if (x2 + y2 > R2) {
                return i;
            }
            y = 2.0 * x * y + ci;
            x = x2 - y2 + cr;
            ++i;
            x2 = x * x;
            y2 = y * y;
        }
        return this._convergenceColor;
    }

    public int checkJulia(double x, double y, double ci, double cr) {
        double t1 = Math.max(Math.abs(x), (double)Math.abs(2));
        double t2 = Math.max(Math.abs(y), (double)Math.abs(2));
        double R2 = Math.sqrt(t1 * t1 + t2 * t2);
        int i = 0;
        double x2 = x * x;
        double y2 = y * y;
        while (i < DEEP) {
            if (x2 + y2 > R2) {
                return i;
            }
            y = 2.0 * x * y + ci;
            x = x2 - y2 + cr;
            ++i;
            x2 = x * x;
            y2 = y * y;
        }
        return this._convergenceColor;
    }
}

