/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal.complex;

public class Complex {
    private double _im;
    private double _re;

    public Complex(double im, double re) {
        this._im = im;
        this._re = re;
    }

    public double getIm() {
        return this._im;
    }

    public double getRe() {
        return this._re;
    }

    public Complex add(Complex a) {
        return new Complex(this._im + a.getIm(), this._re + a.getRe());
    }

    public Complex mult(Complex a) {
        return new Complex(this._re * a.getIm() + a.getRe() * this._im, a.getRe() * this._re + a.getIm() * this._im * -1.0);
    }

    private static double fabs(double a) {
        if (a < 0.0) {
            return a * -1.0;
        }
        return a;
    }

    public boolean equal(Complex a, double epsilon) {
        return Complex.fabs(this._re - a.getRe()) < epsilon && Complex.fabs(this._im - a.getIm()) < epsilon;
    }

    public String toString() {
        return String.valueOf(this._im) + "i+" + this._re;
    }
}

