/*
 * Decompiled with CFR 0.152.
 */
package de.hameister.fractal;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class MandelbrotPanel
extends Frame {
    private int _x;
    private int _y;
    private int[][] _colors;
    private static final int PIXELSIZE = 1;
    private static final int OFFSIZE_X = 10;
    private static final int OFFSIZE_Y = 30;
    public static int COLOR_RED = 0;
    public static int COLOR_BLUE = 1;
    public static int COLOR_GREEN = 2;
    public static int COLOR_MAGENTA = 3;
    public static int COLOR_CYAN = 4;
    public static int COLOR_YELLOW = 5;
    private int _color_scheme;

    public MandelbrotPanel(int xsize, int ysize, int color) {
        this._color_scheme = color;
        this._colors = new int[xsize][ysize];
        this._x = xsize;
        this._y = ysize;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                MandelbrotPanel.this.dispose();
                System.exit(0);
            }
        });
    }

    public void setColorSchema(int color) {
        this._color_scheme = color;
    }

    public void setPoints(int x, int y, int color) {
        this._colors[x][y] = color;
    }

    public void save(File file) {
        BufferedImage bufferedImage = new BufferedImage(this._x, this._y, 1);
        Graphics grImage = bufferedImage.getGraphics();
        this.paintIntoGraphics(grImage);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void paintIntoGraphics(Graphics gr) {
        int imax = 50;
        int x = 0;
        int xx = 0;
        while (x < this._x) {
            int y = 0;
            int yy = 0;
            while (y < this._y) {
                try {
                    double t1 = 1.0 * (double)this._colors[x][y] / (double)imax;
                    int c1 = (int)Math.min(510.0 * t1, 255.0);
                    int c2 = (int)Math.max(255.0 * (2.0 * t1 - 1.0), 0.0);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    switch (this._color_scheme) {
                        case 0: {
                            r = c1;
                            g = c2;
                            b = c2;
                            break;
                        }
                        case 1: {
                            r = c2;
                            g = c1;
                            b = c2;
                            break;
                        }
                        case 2: {
                            r = c2;
                            g = c2;
                            b = c1;
                            break;
                        }
                        case 3: {
                            r = c1;
                            g = c1;
                            b = c2;
                            break;
                        }
                        case 4: {
                            r = c2;
                            g = c1;
                            b = c1;
                            break;
                        }
                        case 5: {
                            r = c1;
                            g = c2;
                            b = c1;
                        }
                    }
                    gr.setColor(new Color(r, b, g));
                }
                catch (IllegalArgumentException ex) {
                    System.out.println("Color=" + this._colors[x][y]);
                    ex.printStackTrace();
                }
                gr.fillRect(xx + 10, yy + 30, 1, 1);
                ++y;
                ++yy;
            }
            ++x;
            ++xx;
        }
    }

    public void paint(Graphics gr) {
        super.paint(gr);
        this.paintIntoGraphics(gr);
    }
}

